// $Id: CPascalString.cpp,v 1.4 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CPascalString.hpp"
using Exponent::Basics::CPascalString;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CPascalString, CCountedObject);

//	===========================================================================
CPascalString::CPascalString(const char *string, const long size) : m_string(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CPascalString);
	NULL_POINTER(m_string);
	this->setString(string, size);
}

//	===========================================================================
CPascalString::~CPascalString()
{
	EXPONENT_CLASS_DESTRUCTION(CPascalString);
	FREE_POINTER(m_string);
}

//	===========================================================================
void CPascalString::setString(const char *string, const long size)
{
	FREE_POINTER(m_string);
	m_string = new char[size];
	char *strPtr = &m_string[1];
	strcpy(strPtr, string);
#ifdef WIN32
	m_string[0] = (char)strlen(string);
#else
	m_string[0] = strlen(string);
#endif
}

//	===========================================================================
char *CPascalString::getString() const 
{ 
	return m_string;
}

//	===========================================================================
const unsigned char *CPascalString::getUnsignedConstString() const 
{ 
	return (unsigned char *)m_string; 
}